USE Obfuscation

IF OBJECT_ID( 'teAddress' ) IS NOT NULL
    DROP TABLE teAddress;

GO

CREATE TABLE teAddress(
    AddressID INT NOT NULL CONSTRAINT pkAddress PRIMARY KEY CLUSTERED,
    PersonID INT NOT NULL,
    AddressType CHAR(4) NOT NULL,
    AddressLine1 VARCHAR(50) NOT NULL,
    AddressLine2 VARCHAR(50) NULL,
    AddressLine3 VARCHAR(50) NULL,
    City VARCHAR(50) NOT NULL,
    [State] CHAR(2) NOT NULL,
    Zip CHAR(5) NOT NULL
)

GO

-- insert the test data
INSERT INTO teAddress(
    AddressID,
    PersonID,
    AddressType,
    AddressLine1,
    AddressLine2,
    AddressLine3,
    City,
    [State],
    Zip
)
SELECT 
    ROW_NUMBER() OVER(ORDER BY P.PersonID),
    P.PersonID, 
    T.AddressType,
    AddressLine1 = A.Value,
    AddressLine2 = NULL,
    AddressLine3 = NULL,
    City = 'Chicago',
    [State] = 'IL',
    Zip = RIGHT( '00000' + CONVERT( VARCHAR(5), ABS(CHECKSUM(NEWID())) % 100000 ), 5 )
FROM tePerson P
CROSS JOIN (
    SELECT AddressType = 'work' UNION ALL
    SELECT 'home'
) AS T
JOIN (
    SELECT L.ID,
        Value = CONVERT( VARCHAR(50), ABS(CHECKSUM(NEWID())) % 1000 ) + ' ' + L.Value + ' St.'
    FROM vLetters L
) AS A
    ON A.ID = ( ABS(CHECKSUM(NEWID())) % 100000 ) * P.PersonID

-- see the test data
SELECT *
FROM teAddress